---
title: Slow down suspicious requests · Cloudflare Rules docs
description: Define a delay to be used when incoming requests match a rule you
  consider suspicious based on the bot score.
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Request modification
source_url:
  html: https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/
  md: https://developers.cloudflare.com/rules/snippets/examples/slow-suspicious-requests/index.md
---

## Snippet code

```js
export default {
  async fetch(request) {
    // Define delay
    const delay_in_seconds = 5;
    // Introduce a delay
    await new Promise((resolve) =>
      setTimeout(resolve, delay_in_seconds * 1000),
    ); // Set delay in milliseconds


    // Pass the request to the origin
    const response = await fetch(request);
    return response;
  },
};
```

## Snippet rule

Configure a custom filter expression:

| Field | Operator | Value |
| - | - | - |
| Bot Score | less than | `10` |

If you are using the Expression Editor, enter the following expression:

```txt
(cf.bot_management.score lt 10)
```
