---
title: Configure a Cloud Connector rule via API · Cloudflare Rules docs
description: You can configure Cloud Connector rules using the Cloudflare API.
lastUpdated: 2025-11-11T11:19:11.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/cloud-connector/create-api/
  md: https://developers.cloudflare.com/rules/cloud-connector/create-api/index.md
---

You can configure Cloud Connector rules using the [Cloudflare API](https://developers.cloudflare.com/fundamentals/api/).

## Required permissions

The [API token](https://developers.cloudflare.com/fundamentals/api/get-started/create-token/) used in API requests to manage Cloud Connector rules must have at least the following permission:

* *Zone* > *Cloud Connector* > *Write*

Note

A token with this permission is only valid for the Cloud Connector endpoints described in this page. You cannot use it to interact with the `http_cloud_connector` phase via [Rulesets API](https://developers.cloudflare.com/ruleset-engine/rulesets-api/).

## Endpoints

To obtain the complete endpoint, append the Cloud Connector endpoints listed below to the Cloudflare API base URL:

```txt
https://api.cloudflare.com/client/v4
```

The `{zone_id}` argument is the [zone ID](https://developers.cloudflare.com/fundamentals/account/find-account-and-zone-ids/) (a hexadecimal string). You can find this value in the Cloudflare dashboard.

The following table summarizes the available operations.

| Operation | Verb + Endpoint |
| - | - |
| List Cloud Connector rules | `GET /zones/{zone_id}/cloud_connector/rules` |
| Create/update/delete Cloud Connector rules | `PUT /zones/{zone_id}/cloud_connector/rules` |

## Example API calls

### List of Cloud Connector rules

The following example returns a list of existing Cloud Connector rules:

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Cloud Connector Read`
* `Cloud Connector Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/cloud_connector/rules" \
  --request GET \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY"
```

```json
{
  "result": [
    {
      "id": "<RULE_1_ID>",
      "provider": "aws_s3",
      "expression": "http.request.uri.path wildcard \"/images/*\"",
      "description": "Connect to S3 bucket containing images",
      "enabled": true,
      "parameters": {
        "host": "examplebucketwithimages.s3.north-eu.amazonaws.com"
      }
    }
  ],
  "success": true,
  "errors": [],
  "messages": []
}
```

### Create/update/delete Cloud Connector rules

Warning

To create a new rule and keep all existing rules, you must include them all in your request body. Omitting an existing rule in the request body will delete the corresponding Cloud Connector rule.

The following example request will replace all existing Cloud Connector rules with a single rule:

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Cloud Connector Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/cloud_connector/rules" \
  --request PUT \
  --header "X-Auth-Email: $CLOUDFLARE_EMAIL" \
  --header "X-Auth-Key: $CLOUDFLARE_API_KEY" \
  --json '[
    {
        "expression": "http.request.uri.path wildcard \"/images/*\"",
        "provider": "cloudflare_r2",
        "description": "Connect to R2 bucket containing images",
        "parameters": {
            "host": "mybucketcustomdomain.example.com"
        }
    }
  ]'
```

The required body parameters for each rule are: `expression`, `provider`, and `parameters.host`.

The `provider` value must be one of the following: `cloudflare_r2`, `aws_s3`, `azure_storage`, and `gcp_storage`.
