---
title: Overview · Cloudflare D1 docs
description: D1 is Cloudflare's managed, serverless database with SQLite's SQL
  semantics, built-in disaster recovery, and Worker and HTTP API access.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/d1/
  md: https://developers.cloudflare.com/d1/index.md
---

Create new serverless SQL databases to query from your Workers and Pages projects.

Available on Free and Paid plans

D1 is Cloudflare's managed, serverless database with SQLite's SQL semantics, built-in disaster recovery, and Worker and HTTP API access.

D1 is designed for horizontal scale out across multiple, smaller (10 GB) databases, such as per-user, per-tenant or per-entity databases. D1 allows you to build applications with thousands of databases at no extra cost for isolating with multiple databases. D1 pricing is based only on query and storage costs.

Create your first D1 database by [following the Get started guide](https://developers.cloudflare.com/d1/get-started/), learn how to [import data into a database](https://developers.cloudflare.com/d1/best-practices/import-export-data/), and how to [interact with your database](https://developers.cloudflare.com/d1/worker-api/) directly from [Workers](https://developers.cloudflare.com/workers/) or [Pages](https://developers.cloudflare.com/pages/functions/bindings/#d1-databases).

***

## Features

### Create your first D1 database

Create your first D1 database, establish a schema, import data and query D1 directly from an application [built with Workers](https://developers.cloudflare.com/workers/).

[Create your D1 database](https://developers.cloudflare.com/d1/get-started/)

### SQLite

Execute SQL with SQLite's SQL compatibility and D1 Client API.

[Execute SQL queries](https://developers.cloudflare.com/d1/sql-api/sql-statements/)

### Time Travel

Time Travel is D1’s approach to backups and point-in-time-recovery, and allows you to restore a database to any minute within the last 30 days.

[Learn about Time Travel](https://developers.cloudflare.com/d1/reference/time-travel/)

***

## Related products

**[Workers](https://developers.cloudflare.com/workers/)**

Build serverless applications and deploy instantly across the globe for exceptional performance, reliability, and scale.

**[Pages](https://developers.cloudflare.com/pages/)**

Deploy dynamic front-end applications in record time.

***

## More resources

[Pricing](https://developers.cloudflare.com/d1/platform/pricing/)

Learn about D1's pricing and how to estimate your usage.

[Limits](https://developers.cloudflare.com/d1/platform/limits/)

Learn about what limits D1 has and how to work within them.

[Community projects](https://developers.cloudflare.com/d1/reference/community-projects/)

Browse what developers are building with D1.

[Storage options](https://developers.cloudflare.com/workers/platform/storage-options/)

Learn more about the storage and database options you can build on with Workers.

[Developer Discord](https://discord.cloudflare.com)

Connect with the Workers community on Discord to ask questions, show what you are building, and discuss the platform with other developers.

[@CloudflareDev](https://x.com/cloudflaredev)

Follow @CloudflareDev on Twitter to learn about product announcements, and what is new in Cloudflare Developer Platform.
