---
title: Cloudflare Tunnel · Cloudflare One docs
description: Magic WAN can work together with Cloudflare Tunnel to provide easy
  access between your networks and applications.
lastUpdated: 2025-11-04T17:07:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/zero-trust/cloudflare-tunnel/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/zero-trust/cloudflare-tunnel/index.md
---

Magic WAN can work together with [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) to provide easy access between your networks and applications.

By default, TCP, UDP, and ICMP traffic routed through Magic WAN tunnels and destined to routes behind Cloudflare Tunnel is proxied and filtered through [Cloudflare Gateway](https://developers.cloudflare.com/cloudflare-one/traffic-policies/).

## Route evaluation and precedence

[Private network routes](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/) are evaluated together across the Cloudflare Tunnel and Magic Networking routing tables. If traffic matches either a Cloudflare Tunnel route (in any virtual network) or a Magic Networking route, the matched route determines the next hop.

When a destination IP matches both a Cloudflare Tunnel private network route and a Magic Networking route, Cloudflare Tunnel takes precedence. This happens whenever a `cloudflared` tunnel CIDR matches a packet, regardless of prefix length. For example, a `cloudflared` tunnel with prefix `10.1.2.0/24` takes precedence over a static route configured to `10.1.2.4/32`, and Cloudflare sends packets over the tunnel instead of a GRE tunnel.

For complex deployments where you need overlapping routes in both Cloudflare Tunnel and Magic Networking, consult your Solutions Engineering team for guidance.

For more information about private network routes with `cloudflared`, refer to [Connect with cloudflared](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/private-net/cloudflared/).

## Test `cloudflared` tunnel integration

To verify that a `cloudflared` tunnel works correctly with your Magic WAN connection:

1. From a host behind your customer premises equipment, open a browser.
2. Browse to an IP address or hostname that is reachable through a Cloudflare Tunnel private network route, such as the example destination `10.1.2.3`.
3. Confirm that the application loads as expected.

If the application loads correctly, Cloudflare Tunnel is handling the traffic as configured.

Run `traceroute`

Magic WAN clients connecting through [GRE](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/), [IPsec](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/configure-tunnel-endpoints/), [CNI](https://developers.cloudflare.com/network-interconnect/) or [WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/) that want to perform a `traceroute` to an endpoint behind a [Cloudflare Tunnel](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/) will need to change some settings to make the command useful. Refer to [Run `traceroute`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/wan-tunnels/configuration/manually/how-to/traceroute/) for more information.
