---
title: Detect a Challenge Page response · Cloudflare challenges docs
description: When a request encounters a Cloudflare Challenge Page instead of
  the originally anticipated response, the Challenge Page response (regardless
  of the Challenge Page type) will have the cf-mitigated header present and set
  to challenge. This header can be leveraged to detect if a response was
  challenged when making fetch/XHR requests. This header provides a reliable way
  to identify whether a response is a Challenge or not, enabling a web
  application to take appropriate action based on the result. For example, a
  front-end application encountering a response from the backend may check the
  presence of this header value to handle cases where Challenge Pages
  encountered unexpectedly.
lastUpdated: 2025-10-13T17:48:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/detect-response/
  md: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/detect-response/index.md
---

When a request encounters a Cloudflare Challenge Page instead of the originally anticipated response, the Challenge Page response (regardless of the Challenge Page type) will have the `cf-mitigated` header present and set to `challenge`. This header can be leveraged to detect if a response was challenged when making fetch/XHR requests. This header provides a reliable way to identify whether a response is a Challenge or not, enabling a web application to take appropriate action based on the result. For example, a front-end application encountering a response from the backend may check the presence of this header value to handle cases where Challenge Pages encountered unexpectedly.

Note

Regardless of the requested resource-type, the content-type of a Challenge will be `text/html`.

For the `cf-mitigated` header, `challenge` is the only valid value. The header is set for all Challenge Page types.

To illustrate, here is a JavaScript code snippet that demonstrates how to use the `cf-mitigated` header to detect whether a response was challenged:

```js
fetch("/my-api-endpoint").then((response) => {
  if (response.headers.get("cf-mitigated") === "challenge") {
    // Handle challenged response
  } else {
    // Process response as usual
  }
});
```
