---
title: Overview · Cloudflare AI Gateway docs
description: Cloudflare's AI Gateway allows you to gain visibility and control
  over your AI apps. By connecting your apps to AI Gateway, you can gather
  insights on how people are using your application with analytics and logging
  and then control how your application scales with features such as caching,
  rate limiting, as well as request retries, model fallback, and more. Better
  yet - it only takes one line of code to get started.
lastUpdated: 2025-08-19T11:42:14.000Z
chatbotDeprioritize: false
tags: AI
source_url:
  html: https://developers.cloudflare.com/ai-gateway/
  md: https://developers.cloudflare.com/ai-gateway/index.md
---

Observe and control your AI applications.

Available on all plans

Cloudflare's AI Gateway allows you to gain visibility and control over your AI apps. By connecting your apps to AI Gateway, you can gather insights on how people are using your application with analytics and logging and then control how your application scales with features such as caching, rate limiting, as well as request retries, model fallback, and more. Better yet - it only takes one line of code to get started.

Check out the [Get started guide](https://developers.cloudflare.com/ai-gateway/get-started/) to learn how to configure your applications with AI Gateway.

## Features

### Analytics

View metrics such as the number of requests, tokens, and the cost it takes to run your application.

[View Analytics](https://developers.cloudflare.com/ai-gateway/observability/analytics/)

### Logging

Gain insight on requests and errors.

[View Logging](https://developers.cloudflare.com/ai-gateway/observability/logging/)

### Caching

Serve requests directly from Cloudflare's cache instead of the original model provider for faster requests and cost savings.

[Use Caching](https://developers.cloudflare.com/ai-gateway/features/caching/)

### Rate limiting

Control how your application scales by limiting the number of requests your application receives.

[Use Rate limiting](https://developers.cloudflare.com/ai-gateway/features/rate-limiting/)

### Request retry and fallback

Improve resilience by defining request retry and model fallbacks in case of an error.

[Use Request retry and fallback](https://developers.cloudflare.com/ai-gateway/features/dynamic-routing/)

### Your favorite providers

Workers AI, OpenAI, Azure OpenAI, HuggingFace, Replicate, and more work with AI Gateway.

[Use Your favorite providers](https://developers.cloudflare.com/ai-gateway/usage/providers/)

***

## Related products

**[Workers AI](https://developers.cloudflare.com/workers-ai/)**

Run machine learning models, powered by serverless GPUs, on Cloudflare’s global network.

**[Vectorize](https://developers.cloudflare.com/vectorize/)**

Build full-stack AI applications with Vectorize, Cloudflare's vector database. Adding Vectorize enables you to perform tasks such as semantic search, recommendations, anomaly detection or can be used to provide context and memory to an LLM.

## More resources

[Developer Discord](https://discord.cloudflare.com)

Connect with the Workers community on Discord to ask questions, show what you are building, and discuss the platform with other developers.

[Use cases](https://developers.cloudflare.com/use-cases/ai/)

Learn how you can build and deploy ambitious AI applications to Cloudflare's global network.

[@CloudflareDev](https://x.com/cloudflaredev)

Follow @CloudflareDev on Twitter to learn about product announcements, and what is new in Cloudflare Workers.
